/* ********************************************************************************
# If you should have any comments, suggestions or improvements to these samples, 
# we welcome you to contact us at SampleCode@melissadata.com also please visit our 
# developers bulletin board at forum.melissadata.com.
# ******************************************************************************** */

/* ********************* LICENSE STRINGS **********************
#*     To unlock the full functionality of Address Object,     *
#* please call a sales representative at 1-800-MELISSA ext. 3  *
#*         (1-800-635-4772 x3) for a license string.           *
#*  Address Object will not function without a valid           *
#*      			  license string 			          	   *
#************************************************************* */

set pagesize 1000;

truncate table log;

declare
  po pls_integer;
  bno varchar2(1000);
  val varchar2(1000);
  ok integer;
begin

  insert into log values('starting');
  commit;

  po := mdParseCreate();
  insert into log values('created mdParse object');
  commit;

  bno := mdParseGetBuildNumber(po);
  insert into log values('build number= ' || bno);
  commit;

  ok := mdParseInitialize(po, 'PATH');
  insert into log values('init datafiles: error=' || ok);
  commit;

  /* test iteratitive interface to mdParse */
  ok := 1;
  mdParseParse(po, '22382 1/2 SW Avenida Empresa Blvd Suite 250 A');
  while ok = 1
  loop
    insert into log values (
      mdParseGetRange(po) || ' ' || 
      mdParseGetPreDirection(po) || ' ' ||
      mdParseGetStreetName(po) || ' ' ||
      mdParseGetSuffix(po) || ' ' ||
      mdParseGetPostDirection(po) || ', ' ||
      mdParseGetSuiteName(po) || ' ' ||
      mdParseGetSuiteNumber(po));
    commit;

    ok := mdParseParseNext(po);
  end loop;

  mdParseDestroy(po);
  insert into log values('destroyed mdParse object');
  commit;

end;
.
run

select * from log;
